set more off
cap log close
clear
set virtual on
set mem 500M

log using sample_means_analysis, replace

*This program compares variance in the public and private sectors in the sample means of each outcome.

*Set paramters
tempfile basedat 
global varlist="tot_med inpat_exp outpat_exp rx_exp no_hosp days_hosp outpat_vis rx_30de"
global varlist_ex="tot_med inpat_exp outpat_exp rx_exp"
global varlist_ut="no_hosp days_hosp outpat_vis rx_30de"


use analytic_file, clear
* Convert dollar values into thousands
foreach i in $varlist_ex {
replace `i'=`i'/1000
}

drop msa_count*

save "`basedat'", replace

*** BASELINE ESTIMATES *** 

** SAMPLE MEANS ESTIMATES **
** No Covariates


foreach i in $varlist {
egen `i'_sd=sd(`i'), by(msa mcbs)
} 

gen msa_count=1

* Step 1: Collapse Data to Mean Values

collapse (sum) msa_count (mean) $varlist *_sd , by(msa mcbs)

* Step 2: Generate variance estimates by outcome

foreach i in $varlist {

* Variance of the sample mean
gen `i'_var=(`i'_sd^2)/msa_count

** Private sample

* Between variance of region means
qui sum `i' if mcbs==0
scalar `i'_obs_sm_priv=r(sd)^2

* Average within variance (the bias)
qui sum `i'_var if mcbs==0
scalar `i'_samperr_priv=r(mean)

* Corrected variance
scalar `i'_corr_sm_priv=`i'_obs_sm_priv-`i'_samperr_priv

** Public sample

* Between variance of region means
qui sum `i' if mcbs==1
scalar `i'_obs_sm_pub=r(sd)^2

* Average within variance (the bias)
qui sum `i'_var if mcbs==1
scalar `i'_samperr_pub=r(mean)

* Corrected variance
scalar `i'_corr_sm_pub=`i'_obs_sm_pub-`i'_samperr_pub

** Uncorrected and corrected variance differences
scalar `i'_var_diff_obs=`i'_obs_sm_pub-`i'_obs_sm_priv
scalar `i'_var_diff_corr=`i'_corr_sm_pub-`i'_corr_sm_priv

** Uncorrected and corrected variance differences
scalar `i'_var_rat_obs=`i'_obs_sm_pub/`i'_obs_sm_priv
scalar `i'_var_rat_corr=`i'_corr_sm_pub/`i'_corr_sm_priv
}


* Put values into matrix
foreach i in $varlist {
matrix EST_`i'=[`i'_obs_sm_priv, `i'_obs_sm_pub, `i'_samperr_priv, `i'_samperr_pub, `i'_corr_sm_priv, `i'_corr_sm_pub, `i'_var_diff_obs, `i'_var_diff_corr, `i'_var_rat_obs, `i'_var_rat_corr]
} 

matrix EST_ut=[EST_no_hosp \ EST_days_hosp \ EST_outpat_vis \ EST_rx_30de]
matrix EST_ex=[EST_tot_med \ EST_inpat_exp \ EST_outpat_exp \ EST_rx_exp]

matrix colnames EST_ut=obs_priv obs_pub samperr_priv samperr_pub cor_priv cor_pub diff_obs diff_cor ratio_obs ratio_cor
matrix colnames EST_ex=obs_priv obs_pub samperr_priv samperr_pub cor_priv cor_pub diff_obs diff_cor ratio_obs ratio_cor
matrix rownames EST_ut=$varlist_ut
matrix rownames EST_ex=$varlist_ex




****** DISPLAY RESULTS
* Utilization
matrix list EST_ut, format(%9.5fc)

* Spending
matrix list EST_ex, format(%9.5fc)

